package gov.va.vamf.scheduling.varutility.service;

import gov.va.vamf.scheduling.varutility.datalayer.CustomMessageRepository;
import gov.va.vamf.scheduling.varutility.domain.CustomMessage;

import gov.va.vamf.scheduling.varutility.domain.CustomMessages;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;

@Service
public class CustomMessageService {

    @Autowired
    private CustomMessageRepository customMessageRepository;

    public CustomMessages fetchCustomMessagesBySiteCode(String siteCode) {
        return customMessageRepository.findBySiteCode(siteCode);
    }

    public CustomMessage fetchCustomMessageBySiteCodeAndMessageId(String siteCode, String messageId) {
        return customMessageRepository.findBySiteCodeAndMessageId(siteCode, messageId);
    }

    public CustomMessage saveCustomMessage(CustomMessage customMessage) {

        customMessage.setLastModifiedDate(new Date());

        return customMessageRepository.save(customMessage);
    }

    public CustomMessages deleteCustomMessagesBySiteCode(String siteCode) {
        return customMessageRepository.deleteBySiteCode(siteCode);
    }
}

